<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Offer Date Widget .
 *
 */
class Tourm_Offer_Date_Widget extends Widget_Base{

	public function get_name() {
		return 'tourmofferdate';
	}

	public function get_title() {
		return __( 'Tourm Offer Date', 'tourm' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'offer_date',
			[
				'label'		=> __( 'Offer Date Countdown','tourm' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);
		        $this->add_control(
			'date', [
				'label' 		=> __( 'Offer End Date With Time', 'tourm' ),
				'type' 			=> Controls_Manager::DATE_TIME,
				'label_block' 	=> true,
			]
        );

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$offer_date_end = $settings['date'];
		$replace 	= array('-');
		$with 		= array('/');

		$date 	= str_replace( $replace, $with, $offer_date_end );
		echo '<!-----------------------Start Offer Date Area----------------------->';

		echo '<ul class="offer-deals-counter counter-list" data-offer-date="'.esc_attr($date).'">';
            echo '<li>';
                echo '<div class="day count-number">00</div>';
                echo '<span class="count-name">'.esc_html('Days', 'tourm').'</span>';
            echo '</li>';
            echo '<li>';
                echo '<div class="hour count-number">00</div>';
                echo '<span class="count-name">'.esc_html('Hours', 'tourm').'</span>';
            echo '</li>';
            echo '<li>';
                echo '<div class="minute count-number">00</div>';
                echo '<span class="count-name">'.esc_html('Minutes', 'tourm').'</span>';
            echo '</li>';
            echo '<li>';
                echo '<div class="seconds count-number">00</div>';
                echo '<span class="count-name">'.esc_html('Seconds', 'tourm').'</span>';
            echo '</li>';
        echo '</ul>';
	}
}