<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * CTA Widget .
 *
 */
class tourm_CTA extends Widget_Base {

	public function get_name() {
		return 'tourcta';
	}
	public function get_title() {
		return __( 'CTA', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'CTA Style', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', ['Style One'] );


		tourm_media_fields( $this, 'image', 'Background', ['1'] );

		tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Sign Up For CTA' );
		tourm_general_fields( $this, 'desc', 'Description', 'TEXTAREA', 'Sign Up For CTA' );


		tourm_general_fields( $this, 'btn_text', 'Button Text', 'TEXT', 'Button Text', ['1'] );
		tourm_general_fields( $this, 'btn_url', 'Button Url', 'URL', '#', ['1'] );



        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		//-------Title Style-------
		tourm_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .title1','','--white-color');
		tourm_common_style_fields($this, 'subtitle', 'Subtitle', '{{WRAPPER}} .title2','','--white-color');


		tourm_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .th-btn', ['1']);

		//-------Description Style-------


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			$image = $settings['image']['url'] ? $settings['image']['url'] : '#';

			echo '<div class="history-area overflow-hidden" data-bg-src="'.esc_url( $image ).'">';
                echo '<div class="history-content">';
                    echo '<div class="title-area">';
                    	if(!empty( $settings['title'] )){
	                        echo '<h3 class="sec-title title1">'.esc_html( $settings['title'] ).'</h3>';
	                    }
	                    if(!empty( $settings['desc'] )){
	                        echo '<p class="sec-text title2">'.esc_html( $settings['desc'] ).'</p>';
	                    }
                    echo '</div>';
                    if(!empty($settings['btn_text'])){
	                    echo '<div class="btn-group">';
	                        echo '<a href="'.esc_url($settings['btn_url']).'" class="th-btn style1 th-icon">'.esc_html($settings['btn_text']).'</a>';
	                    echo '</div>';
	                }
                echo '</div>';

            echo '</div>';
		}
	}
}
						