<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Widget .
 *
 */
class tourm_Feature extends Widget_Base {

	public function get_name() {
		return 'tourmfeatures';
	}
	public function get_title() {
		return __( 'Tourm Features', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Features', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six', 'Style Seven', 'Style Eight', 'Style Nine', 'Style Ten', 'Style Eleven', 'Style Twelve', 'Style Thirteen'] );

		$fields_to_include = [ 'image' => ['Icon Image'], 'title' => ['Title','Description'] ];
		tourm_repeater_fields( $this, 'service_list', 'Feature Lists', $fields_to_include, ['1','2','3','4','5','6','7','8','9','10','11'] );


		$fields_to_include2 = [ 'image' => ['Icon Image'], 'title' => ['Title','Description'],'btn' => ['Button Text'], 'url' => ['URL'] ];
		tourm_repeater_fields( $this, 'service_list2', 'Feature Lists', $fields_to_include2, ['12','13'] );

		tourm_gallery_fields( $this, 'brand_logo', 'Author', ['5'] );

		tourm_media_fields( $this, 'image1', 'Choose Image', ['5'] );

		tourm_general_fields( $this, 'counter', 'Counter', 'WYSIWYG', 'Sign Up For Newsletter' );

		


        $this->end_controls_section();

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .box-title', ['1','2','3','4','5','6','7','8','9','10','11','12','13'] );
		tourm_common2_style_fields( $this, 'title3', 'Description', '{{WRAPPER}} .desc', ['1','2','3','4','5','6','7','8','9','10','11','12','13'] );


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="about-item-wrap">';
                foreach( $settings['service_list'] as $data ){            
	                echo '<div class="about-item">';
	                	if(!empty($data['icon_image']['url'])){
		                    echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                    echo '<div class="about-item_centent">';
	                    	if(!empty($data['title'])){
		                        echo '<h5 class="box-title title">'.esc_html($data['title']).'</h5>';
		                    }
		                    if(!empty($data['description'])){
		                        echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="about-item-wrap">';
                foreach( $settings['service_list'] as $data ){            
	                echo '<div class="about-item style2">';
	                	if(!empty($data['icon_image']['url'])){
		                    echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                    echo '<div class="about-item_centent">';
	                    	if(!empty($data['title'])){
		                        echo '<h5 class="box-title title">'.esc_html($data['title']).'</h5>';
		                    }
		                    if(!empty($data['description'])){
		                        echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4 justify-content-center">';
                foreach( $settings['service_list'] as $data ){    
	                echo '<div class="col-md-6 col-xl-3">';
	                    echo '<div class="feature-item th-ani">';
	                    	if(!empty($data['icon_image']['url'])){
		                        echo '<div class="feature-item_icon">';
		                            echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="icon">';
		                        echo '</div>';
		                    }
	                        echo '<div class="media-body">';
	                        	if(!empty($data['title'])){
			                        echo '<h3 class="box-title title">'.esc_html($data['title']).'</h3>';
			                    }
			                    if(!empty($data['description'])){
		                            echo '<p class="feature-item_text desc">'.esc_html($data['description']).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			foreach( $settings['service_list'] as $data ){ 
				echo '<div class="choose-about wow fadeInUp">';
					if(!empty($data['icon_image']['url'])){
		                echo '<div class="choose-about_icon">';
		                    echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="icon">';
		                echo '</div>';
		            }
	                echo '<div class="media-body">';
	                    if(!empty($data['title'])){
	                        echo '<h3 class="box-title ">'.esc_html($data['title']).'</h3>';
	                    }
	                    if(!empty($data['description'])){
		                    echo '<p class="choose-about_text desc">'.esc_html($data['description']).'</p>';
		                }
	                echo '</div>';
	            echo '</div>';
	        }
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="about-content-wrapper">';
                echo '<div class="about-item-wrap">';
                    echo '<div class="about-client-box">';
                        echo '<div class="client-thumb-group">';
                        	foreach ( $settings['brand_logo'] as $single_data ) {
	                            echo '<div class="thumb"><img src="'.esc_url( $single_data['url']  ).'" alt="avater"></div>';
	                        }
                            echo '<div class="thumb icon"><i class="fa-light fa-plus"></i> </div>';
                        echo '</div>';
                    echo '</div>';
                    foreach( $settings['service_list'] as $data ){ 
	                   	echo ' <div class="about-item style2">';
	                   		if(!empty($data['icon_image']['url'])){
		                        echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                    }
	                        echo '<div class="about-item_centent">';
	                            if(!empty($data['title'])){
			                        echo '<h5 class="box-title ">'.esc_html($data['title']).'</h5>';
			                    }
			                    if(!empty($data['description'])){
		                            echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                echo '<div class="about-image9">';
                	if(!empty($settings['image1']['url'])){
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                }
	                if(!empty( $settings['counter'] )){
	                	echo wp_kses_post( $settings['counter'] );
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			$i = 0;
			foreach( $settings['service_list'] as $data ){ 
				$i++;

				$active_class = $i == 1 ? 'item-active' : '';
				echo '<div class="choose-about style2 hover-item '.esc_attr( $active_class ).'">';
					if(!empty($data['icon_image']['url'])){
		                echo '<div class="choose-about_icon">';
		                    echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="image">';
		                echo '</div>';
		            }
	                echo '<div class="media-body">';
	                    if(!empty($data['title'])){
	                        echo '<h3 class="box-title ">'.esc_html($data['title']).'</h3>';
	                    }
	                    if(!empty($data['description'])){
		                    echo '<p class="choose-about_text desc">'.esc_html($data['description']).'</p>';
		                }
	                echo '</div>';
	            echo '</div>';
	        }
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="about-item-wrap style2">';
            	foreach( $settings['service_list'] as $data ){ 
	                echo '<div class="about-item style2">';
	                	if(!empty($data['icon_image']['url'])){
		                    echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                    echo '<div class="about-item_centent">';
	                    	if(!empty($data['title'])){
		                        echo '<h5 class="box-title">'.esc_html($data['title']).'</h5>';
		                    }
		                    if(!empty($data['description'])){
		                        echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '8' ){
			echo '<div class="row gy-80">';

                foreach( $settings['service_list'] as $data ){ 
	                echo '<div class="col-md-6 col-xl-4">';
	                    echo '<div class="choose-item">';
	                    	if(!empty($data['icon_image']['url'])){
		                        echo '<div class="box-icon">';
		                            echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="image">';
		                        echo '</div>';
		                    }
	                        echo '<div class="media-body">';
	                            if(!empty($data['title'])){
			                        echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                    }
			                    if(!empty($data['description'])){
		                            echo '<p class="box-text desc">'.esc_html($data['description']).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '9' ){
			echo '<div class="about-item-wrap style3">';
               	foreach( $settings['service_list'] as $data ){            
	                echo '<div class="about-item style3">';
	                	if(!empty($data['icon_image']['url'])){
		                    echo '<div class="about-item_img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                    echo '<div class="about-item_centent">';
	                    	if(!empty($data['title'])){
		                        echo '<h5 class="box-title">'.esc_html($data['title']).'</h5>';
		                    }
		                    if(!empty($data['description'])){
	                            echo '<p class="about-item_text desc">'.esc_html($data['description']).'</p>';
	                        }
	                    echo '</div>';
	                echo '</div>';
	            }
                

            echo '</div>';
		}elseif( $settings['layout_style'] == '10' ){
			echo '<div class="container th-container">';
				echo '<div class="choose-item_wrapper">';
					foreach( $settings['service_list'] as $data ){ 
		                echo '<div class="choose-item style3">';
		                	if(!empty($data['icon_image']['url'])){
			                    echo '<div class="box-icon">';
			                        echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="image">';
			                    echo '</div>';
			                }
		                    echo '<div class="media-body">';
		                    	if(!empty($data['title'])){
			                        echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                    }
			                    if(!empty($data['description'])){
		                            echo '<p class="box-text desc">'.esc_html($data['description']).'</p>';
		                        }
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '11' ){
			echo '<div class="row gy-4 justify-content-center justify-content-lg-between">';
                foreach( $settings['service_list'] as $data ){     
	                echo '<div class="col-lg-4 col-md-6 choose-feature_wrapp">';
	                    echo '<div class="choose-feature">';
	                        if(!empty($data['icon_image']['url'])){
			                    echo '<div class="box-img">';
			                        echo '<img src="'.esc_url( $data['icon_image']['url'] ).'" alt="image">';
			                    echo '</div>';
			                }
	                        echo '<div class="choose-feature_content">';
	                        	if(!empty($data['title'])){
			                        echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
			                    }
			                    if(!empty($data['description'])){
		                            echo '<p class="box-text desc">'.esc_html($data['description']).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '12' ){
			echo '<div class="about-card2-wrap">';

				foreach( $settings['service_list2'] as $data ){   
	                echo '<div class="about-card2">';
	                    echo '<div class="box-centent">';
	                        if(!empty($data['title'])){
		                        echo '<h5 class="box-title">'.esc_html($data['title']).'</h5>';
		                    }
	                        if(!empty($data['description'])){
	                            echo '<p class="box-text desc">'.esc_html($data['description']).'</p>';
	                        }
	                        if(!empty($data['button_text'])){
		                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="line-btn th-icon">'.esc_html($data['button_text']).'</a>';
		                    }
	                    echo '</div>';
	                    if(!empty($data['icon_image']['url'])){
		                    echo '<div class="box-img"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></div>';
		                }
	                echo '</div>';
	            }
                

            echo '</div>';
		}else{
			echo '<div class="row gy-4 justify-content-center">';

                foreach( $settings['service_list2'] as $data ){ 
	                echo '<div class="col-xl-4 col-md-6">';
	                    echo '<div class="story-box">';
	                        if(!empty($data['title'])){
		                        echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
		                    }
		                    if(!empty($data['description'])){
		                        echo '<p class="story-box_text desc">'.esc_html($data['description']).'</p>';
		                    }
		                    if(!empty($data['icon_image']['url'])){
		                        echo '<span class="story-box_icon"><img src="'.esc_url( $data['icon_image']['url'] ).'" alt=""></span>';
		                    }
		                    if(!empty($data['button_text'])){
			                    echo '<a href="'.esc_url( $data['url']['url'] ).'">';
			                        echo '<div class="icon"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/arrow-up.svg" alt=""></div>';
			                        echo '<div class="discount-wrapp">';
			                            echo '<div class="discount-tag">';
			                                echo '<span class="discount-anime">'.esc_html($data['button_text']).'</span>';
			                            echo '</div>';
			                        echo '</div>';
		                        echo '</a>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }

                
            echo '</div>';
		}
	}
}