<?php
/**
 * The Template for displaying room archive pages
 *
 * @package Tourm Child
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 */
do_action( 'woocommerce_before_main_content' );
?>

<header class="woocommerce-products-header rooms-archive-header">
    <?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
        <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
    <?php endif; ?>
</header>

<div class="rooms-archive-wrapper">
    <div class="container">
        <div class="row">
            
            <!-- Filters Sidebar -->
            <div class="col-lg-3">
                <aside class="rooms-filters-sidebar">
                    <h3>Filters</h3>
                    
                    <!-- Category Filter -->
                    <?php
                    $categories = get_terms( array(
                        'taxonomy' => 'product_cat',
                        'hide_empty' => true,
                    ) );
                    if ( !empty( $categories ) && !is_wp_error( $categories ) ) :
                        ?>
                        <div class="filter-group">
                            <h4>Room Categories</h4>
                            <ul class="filter-list">
                                <?php foreach ( $categories as $category ) : ?>
                                    <li>
                                        <a href="<?php echo esc_url( get_term_link( $category ) ); ?>">
                                            <?php echo esc_html( $category->name ); ?>
                                            <span class="count">(<?php echo esc_html( $category->count ); ?>)</span>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <!-- Price Range Filter -->
                    <div class="filter-group">
                        <h4>Price Range</h4>
                        <div class="price-range-filter">
                            <input type="range" id="price-min" min="0" max="1000" value="0" />
                            <input type="range" id="price-max" min="0" max="1000" value="1000" />
                            <div class="price-display">
                                <span id="price-min-display">$0</span> - <span id="price-max-display">$1000</span>
                            </div>
                        </div>
                    </div>

                    <!-- Occupancy Filter -->
                    <div class="filter-group">
                        <h4>Max Guests</h4>
                        <select id="occupancy-filter" class="form-control">
                            <option value="">All</option>
                            <option value="1">1 Guest</option>
                            <option value="2">2 Guests</option>
                            <option value="3">3 Guests</option>
                            <option value="4">4 Guests</option>
                            <option value="5+">5+ Guests</option>
                        </select>
                    </div>

                    <!-- Amenities Filter -->
                    <div class="filter-group">
                        <h4>Amenities</h4>
                        <div class="amenities-filter">
                            <label><input type="checkbox" value="wifi" /> WiFi</label>
                            <label><input type="checkbox" value="tv" /> TV</label>
                            <label><input type="checkbox" value="ac" /> Air Conditioning</label>
                            <label><input type="checkbox" value="breakfast" /> Breakfast</label>
                            <label><input type="checkbox" value="pool_access" /> Pool Access</label>
                            <label><input type="checkbox" value="ocean_view" /> Ocean View</label>
                        </div>
                    </div>

                    <button type="button" class="btn btn-primary btn-filter" id="apply-filters">Apply Filters</button>
                    <button type="button" class="btn btn-outline-secondary btn-reset" id="reset-filters">Reset</button>
                </aside>
            </div>

            <!-- Rooms Grid -->
            <div class="col-lg-9">
                <?php
                if ( woocommerce_product_loop() ) :

                    /**
                     * Hook: woocommerce_before_shop_loop.
                     */
                    do_action( 'woocommerce_before_shop_loop' );

                    woocommerce_product_loop_start();

                    if ( wc_get_loop_prop( 'is_shortcode' ) ) {
                        $columns = absint( wc_get_loop_prop( 'columns' ) );
                        wc_set_loop_prop( 'columns', $columns );
                    }

                    while ( have_posts() ) {
                        the_post();

                        /**
                         * Hook: woocommerce_shop_loop.
                         */
                        do_action( 'woocommerce_shop_loop' );

                        wc_get_template_part( 'content', 'product' );
                    }

                    woocommerce_product_loop_end();

                    /**
                     * Hook: woocommerce_after_shop_loop.
                     */
                    do_action( 'woocommerce_after_shop_loop' );

                else :

                    /**
                     * Hook: woocommerce_no_products_found.
                     */
                    do_action( 'woocommerce_no_products_found' );

                endif;
                ?>
            </div>

        </div>
    </div>
</div>

<?php
/**
 * Hook: woocommerce_after_main_content.
 */
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
