<?php
/**
 * The Template for displaying all single rooms
 *
 * @package Tourm Child
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 */
do_action( 'woocommerce_before_main_content' );

while ( have_posts() ) :
    the_post();
    global $product;
    ?>

    <div class="room-booking-wrapper">
        <div class="container">
            <div class="row">
                <!-- Left Side: Main Content -->
                <div class="col-lg-8">
                    <div class="room-main-content">
                        
                        <!-- Room Title -->
                        <div class="room-header">
                            <h1 class="room-title"><?php the_title(); ?></h1>
                            <?php if ( $product->get_rating_count() ) : ?>
                                <div class="room-rating">
                                    <?php woocommerce_template_loop_rating(); ?>
                                    <span class="rating-count">(<?php echo esc_html( $product->get_review_count() ); ?> reviews)</span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Room Gallery -->
                        <div class="room-gallery">
                            <?php
                            $gallery_ids = $product->get_gallery_image_ids();
                            if ( $gallery_ids || has_post_thumbnail() ) :
                                ?>
                                <div class="room-gallery-slider">
                                    <div class="swiper room-main-slider">
                                        <div class="swiper-wrapper">
                                            <?php if ( has_post_thumbnail() ) : ?>
                                                <div class="swiper-slide">
                                                    <?php the_post_thumbnail( 'large', array( 'class' => 'room-gallery-image' ) ); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php foreach ( $gallery_ids as $image_id ) : ?>
                                                <div class="swiper-slide">
                                                    <?php echo wp_get_attachment_image( $image_id, 'large', false, array( 'class' => 'room-gallery-image' ) ); ?>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <div class="swiper-pagination"></div>
                                        <div class="swiper-button-next"></div>
                                        <div class="swiper-button-prev"></div>
                                    </div>
                                    <?php if ( $gallery_ids ) : ?>
                                        <div class="room-gallery-thumbs">
                                            <div class="swiper room-thumbs-slider">
                                                <div class="swiper-wrapper">
                                                    <?php if ( has_post_thumbnail() ) : ?>
                                                        <div class="swiper-slide">
                                                            <?php the_post_thumbnail( 'thumbnail', array( 'class' => 'room-thumb-image' ) ); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php foreach ( $gallery_ids as $image_id ) : ?>
                                                        <div class="swiper-slide">
                                                            <?php echo wp_get_attachment_image( $image_id, 'thumbnail', false, array( 'class' => 'room-thumb-image' ) ); ?>
                                                        </div>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Room Description -->
                        <div class="room-description">
                            <h2 class="section-title">Description</h2>
                            <div class="room-content">
                                <?php the_content(); ?>
                            </div>
                        </div>

                        <!-- Room Details -->
                        <div class="room-details">
                            <h2 class="section-title">Room Details</h2>
                            <div class="room-details-grid">
                                <?php
                                $room_size = get_post_meta( get_the_ID(), '_room_size', true );
                                $room_occupancy = get_post_meta( get_the_ID(), '_room_occupancy', true );
                                $room_max_guests = get_post_meta( get_the_ID(), '_room_max_guests', true );
                                $room_type = get_post_meta( get_the_ID(), '_room_type', true );
                                $room_view = get_post_meta( get_the_ID(), '_room_view', true );
                                $room_bed_type = get_post_meta( get_the_ID(), '_room_bed_type', true );
                                ?>
                                <?php if ( $room_size ) : ?>
                                    <div class="detail-item">
                                        <i class="fas fa-ruler-combined"></i>
                                        <div>
                                            <strong>Size</strong>
                                            <span><?php echo esc_html( $room_size ); ?> sq ft</span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ( $room_max_guests ) : ?>
                                    <div class="detail-item">
                                        <i class="fas fa-users"></i>
                                        <div>
                                            <strong>Max Guests</strong>
                                            <span><?php echo esc_html( $room_max_guests ); ?></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ( $room_type ) : ?>
                                    <div class="detail-item">
                                        <i class="fas fa-door-open"></i>
                                        <div>
                                            <strong>Room Type</strong>
                                            <span><?php echo esc_html( ucfirst( $room_type ) ); ?></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ( $room_view ) : ?>
                                    <div class="detail-item">
                                        <i class="fas fa-eye"></i>
                                        <div>
                                            <strong>View</strong>
                                            <span><?php echo esc_html( ucfirst( str_replace( '_', ' ', $room_view ) ) ); ?></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ( $room_bed_type ) : ?>
                                    <div class="detail-item">
                                        <i class="fas fa-bed"></i>
                                        <div>
                                            <strong>Bed Type</strong>
                                            <span><?php echo esc_html( ucfirst( $room_bed_type ) ); ?></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ( $room_occupancy ) : ?>
                                    <div class="detail-item">
                                        <i class="fas fa-user-friends"></i>
                                        <div>
                                            <strong>Occupancy</strong>
                                            <span><?php echo esc_html( $room_occupancy ); ?></span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Amenities -->
                        <div class="room-amenities">
                            <h2 class="section-title">Amenities</h2>
                            <?php
                            $amenities = get_post_meta( get_the_ID(), '_room_amenities', true );
                            if ( is_array( $amenities ) && !empty( $amenities ) ) :
                                $amenity_icons = array(
                                    'wifi' => 'fas fa-wifi',
                                    'tv' => 'fas fa-tv',
                                    'ac' => 'fas fa-snowflake',
                                    'minibar' => 'fas fa-wine-bottle',
                                    'safe' => 'fas fa-lock',
                                    'balcony' => 'fas fa-door-open',
                                    'ocean_view' => 'fas fa-water',
                                    'room_service' => 'fas fa-concierge-bell',
                                    'breakfast' => 'fas fa-coffee',
                                    'parking' => 'fas fa-parking',
                                    'pool_access' => 'fas fa-swimming-pool',
                                    'gym_access' => 'fas fa-dumbbell',
                                    'spa' => 'fas fa-spa',
                                    'kitchen' => 'fas fa-utensils',
                                    'washing_machine' => 'fas fa-tshirt',
                                );
                                $amenity_labels = array(
                                    'wifi' => 'WiFi',
                                    'tv' => 'TV',
                                    'ac' => 'Air Conditioning',
                                    'minibar' => 'Minibar',
                                    'safe' => 'Safe',
                                    'balcony' => 'Balcony',
                                    'ocean_view' => 'Ocean View',
                                    'room_service' => 'Room Service',
                                    'breakfast' => 'Breakfast Included',
                                    'parking' => 'Parking',
                                    'pool_access' => 'Pool Access',
                                    'gym_access' => 'Gym Access',
                                    'spa' => 'Spa Access',
                                    'kitchen' => 'Kitchen',
                                    'washing_machine' => 'Washing Machine',
                                );
                                ?>
                                <div class="amenities-grid">
                                    <?php foreach ( $amenities as $amenity ) : ?>
                                        <div class="amenity-item">
                                            <i class="<?php echo esc_attr( isset( $amenity_icons[ $amenity ] ) ? $amenity_icons[ $amenity ] : 'fas fa-check' ); ?>"></i>
                                            <span><?php echo esc_html( isset( $amenity_labels[ $amenity ] ) ? $amenity_labels[ $amenity ] : ucfirst( str_replace( '_', ' ', $amenity ) ) ); ?></span>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Pricing Table -->
                        <div class="room-pricing-table">
                            <h2 class="section-title">Pricing</h2>
                            <div class="pricing-info">
                                <?php
                                $pricing_type = get_post_meta( get_the_ID(), '_pricing_type', true );
                                $price_per_night = get_post_meta( get_the_ID(), '_price_per_night', true );
                                $price_per_person = get_post_meta( get_the_ID(), '_price_per_person', true );
                                ?>
                                <div class="price-display">
                                    <?php if ( $pricing_type == 'per_night' && $price_per_night ) : ?>
                                        <p><strong>Price per night:</strong> <?php echo wc_price( $price_per_night ); ?></p>
                                    <?php elseif ( $pricing_type == 'per_person' && $price_per_person ) : ?>
                                        <p><strong>Price per person per night:</strong> <?php echo wc_price( $price_per_person ); ?></p>
                                    <?php elseif ( $pricing_type == 'per_night_per_person' ) : ?>
                                        <p><strong>Base price per night:</strong> <?php echo wc_price( $price_per_night ); ?></p>
                                        <p><strong>Additional per person:</strong> <?php echo wc_price( $price_per_person ); ?></p>
                                    <?php else : ?>
                                        <p><strong>Price:</strong> <?php echo $product->get_price_html(); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Extra Services -->
                        <?php
                        $extra_services = get_post_meta( get_the_ID(), '_extra_services', true );
                        if ( is_array( $extra_services ) && !empty( $extra_services ) ) :
                            ?>
                            <div class="room-extra-services">
                                <h2 class="section-title">Extra Services</h2>
                                <div class="extra-services-list">
                                    <?php foreach ( $extra_services as $index => $service ) : ?>
                                        <div class="extra-service-item">
                                            <strong><?php echo esc_html( $service['name'] ); ?></strong>
                                            <span class="service-price">
                                                <?php echo wc_price( $service['price'] ); ?>
                                                <small>(<?php echo esc_html( str_replace( '_', ' ', $service['type'] ) ); ?>)</small>
                                            </span>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Availability Calendar -->
                        <div class="room-availability-calendar">
                            <h2 class="section-title">Availability Calendar</h2>
                            <div id="availability-calendar" data-room-id="<?php echo esc_attr( get_the_ID() ); ?>"></div>
                        </div>

                        <!-- Related Rooms -->
                        <?php
                        woocommerce_output_related_products();
                        ?>

                    </div>
                </div>

                <!-- Right Side: Booking Sidebar -->
                <div class="col-lg-4">
                    <div class="room-booking-sidebar">
                        <?php include get_stylesheet_directory() . '/woocommerce/single-product/booking-form.php'; ?>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php
endwhile;

/**
 * Hook: woocommerce_after_main_content.
 */
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
