<?php
/**
 * Room Booking Form Sidebar
 */

defined( 'ABSPATH' ) || exit;

global $product;

$min_stay = get_post_meta( get_the_ID(), '_min_stay', true );
$max_stay = get_post_meta( get_the_ID(), '_max_stay', true );
$max_guests = get_post_meta( get_the_ID(), '_room_max_guests', true );
$check_in_time = get_post_meta( get_the_ID(), '_check_in_time', true );
$check_out_time = get_post_meta( get_the_ID(), '_check_out_time', true );
$deposit_percentage = get_post_meta( get_the_ID(), '_deposit_percentage', true );
$extra_services = get_post_meta( get_the_ID(), '_extra_services', true );

if ( empty( $check_in_time ) ) {
    $check_in_time = '14:00';
}
if ( empty( $check_out_time ) ) {
    $check_out_time = '11:00';
}
if ( empty( $deposit_percentage ) ) {
    $deposit_percentage = 30;
}
if ( !is_array( $extra_services ) ) {
    $extra_services = array();
}

$booked_dates = get_room_booked_dates( get_the_ID() );
?>

<div class="booking-form-wrapper" id="booking-form-wrapper">
    <div class="booking-form-header">
        <h3>Book This Room</h3>
        <?php if ( $product->get_price_html() ) : ?>
            <div class="room-price-display">
                <span class="price-label">From</span>
                <span class="price-amount"><?php echo $product->get_price_html(); ?></span>
                <span class="price-period">per night</span>
            </div>
        <?php endif; ?>
    </div>

    <form class="room-booking-form" id="room-booking-form" method="post" action="<?php echo esc_url( wc_get_cart_url() ); ?>">
        
        <!-- Check-in Date -->
        <div class="form-group">
            <label for="check_in_date">Check-in Date</label>
            <input type="text" id="check_in_date" name="check_in_date" class="form-control date-picker" required readonly />
            <?php if ( $check_in_time ) : ?>
                <small class="form-text">Check-in time: <?php echo esc_html( $check_in_time ); ?></small>
            <?php endif; ?>
        </div>

        <!-- Check-out Date -->
        <div class="form-group">
            <label for="check_out_date">Check-out Date</label>
            <input type="text" id="check_out_date" name="check_out_date" class="form-control date-picker" required readonly />
            <?php if ( $check_out_time ) : ?>
                <small class="form-text">Check-out time: <?php echo esc_html( $check_out_time ); ?></small>
            <?php endif; ?>
        </div>

        <!-- Guests -->
        <div class="form-group">
            <label for="adults">Adults</label>
            <select id="adults" name="adults" class="form-control" required>
                <?php
                $max_adults = $max_guests ? $max_guests : 10;
                for ( $i = 1; $i <= $max_adults; $i++ ) :
                    ?>
                    <option value="<?php echo $i; ?>" <?php selected( $i, 2 ); ?>><?php echo $i; ?></option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="children">Children</label>
            <select id="children" name="children" class="form-control">
                <?php for ( $i = 0; $i <= 5; $i++ ) : ?>
                    <option value="<?php echo $i; ?>"><?php echo $i; ?></option>
                <?php endfor; ?>
            </select>
        </div>

        <!-- Extra Services -->
        <?php if ( !empty( $extra_services ) ) : ?>
            <div class="form-group extra-services-group">
                <label>Extra Services</label>
                <div class="extra-services-checkboxes">
                    <?php foreach ( $extra_services as $index => $service ) : ?>
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input extra-service-checkbox" 
                                   id="extra_service_<?php echo $index; ?>" 
                                   name="extra_services[]" 
                                   value="<?php echo $index; ?>"
                                   data-price="<?php echo esc_attr( $service['price'] ); ?>"
                                   data-type="<?php echo esc_attr( $service['type'] ); ?>" />
                            <label class="form-check-label" for="extra_service_<?php echo $index; ?>">
                                <?php echo esc_html( $service['name'] ); ?>
                                <span class="service-price"><?php echo wc_price( $service['price'] ); ?></span>
                            </label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Price Summary -->
        <div class="booking-price-summary">
            <div class="price-row">
                <span class="price-label">Nights:</span>
                <span class="price-value" id="nights-count">-</span>
            </div>
            <div class="price-row">
                <span class="price-label">Base Price:</span>
                <span class="price-value" id="base-price">-</span>
            </div>
            <div class="price-row" id="extra-services-row" style="display: none;">
                <span class="price-label">Extra Services:</span>
                <span class="price-value" id="extra-services-price">-</span>
            </div>
            <div class="price-row price-total">
                <span class="price-label">Total:</span>
                <span class="price-value" id="total-price"><?php echo wc_price( 0 ); ?></span>
            </div>
        </div>

        <!-- Payment Options -->
        <div class="form-group payment-options">
            <label>Payment Option</label>
            <div class="payment-radio-group">
                <div class="form-check">
                    <input type="radio" class="form-check-input" id="payment_full" name="payment_type" value="full" checked />
                    <label class="form-check-label" for="payment_full">
                        Pay Full Amount
                    </label>
                </div>
                <div class="form-check">
                    <input type="radio" class="form-check-input" id="payment_deposit" name="payment_type" value="deposit" />
                    <label class="form-check-label" for="payment_deposit">
                        Pay Deposit (<?php echo esc_html( $deposit_percentage ); ?>%)
                    </label>
                </div>
            </div>
            <div class="deposit-info" id="deposit-info" style="display: none;">
                <div class="price-row">
                    <span class="price-label">Deposit:</span>
                    <span class="price-value" id="deposit-amount">-</span>
                </div>
                <div class="price-row">
                    <span class="price-label">Remaining Balance:</span>
                    <span class="price-value" id="remaining-balance">-</span>
                </div>
            </div>
        </div>

        <!-- Add to Cart Button -->
        <input type="hidden" name="add-to-cart" value="<?php echo esc_attr( get_the_ID() ); ?>" />
        <button type="submit" class="btn btn-primary btn-book-now" id="book-now-btn">
            Book Now
        </button>

        <!-- Inquiry Button -->
        <button type="button" class="btn btn-outline-secondary btn-inquiry" id="inquiry-btn">
            Ask a Question
        </button>

        <!-- Validation Messages -->
        <div id="booking-messages" class="booking-messages"></div>

    </form>

    <!-- Inquiry Form Modal -->
    <div class="modal fade" id="inquiry-modal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ask a Question</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="inquiry-form">
                        <div class="form-group">
                            <label for="inquiry_name">Your Name</label>
                            <input type="text" id="inquiry_name" name="name" class="form-control" required />
                        </div>
                        <div class="form-group">
                            <label for="inquiry_email">Your Email</label>
                            <input type="email" id="inquiry_email" name="email" class="form-control" required />
                        </div>
                        <div class="form-group">
                            <label for="inquiry_message">Your Message</label>
                            <textarea id="inquiry_message" name="message" class="form-control" rows="5" required></textarea>
                        </div>
                        <input type="hidden" name="room_id" value="<?php echo esc_attr( get_the_ID() ); ?>" />
                        <button type="submit" class="btn btn-primary">Send Inquiry</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

</div>

<script type="text/javascript">
    var roomBookingData = {
        roomId: <?php echo esc_js( get_the_ID() ); ?>,
        bookedDates: <?php echo json_encode( $booked_dates ); ?>,
        minStay: <?php echo esc_js( $min_stay ? $min_stay : 1 ); ?>,
        maxStay: <?php echo esc_js( $max_stay ? $max_stay : 0 ); ?>,
        maxGuests: <?php echo esc_js( $max_guests ? $max_guests : 10 ); ?>,
        depositPercentage: <?php echo esc_js( $deposit_percentage ); ?>,
        currencySymbol: '<?php echo esc_js( get_woocommerce_currency_symbol() ); ?>',
        currencyPosition: '<?php echo esc_js( get_option( 'woocommerce_currency_pos' ) ); ?>'
    };
</script>
