<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Price Widget .
 *
 */
class Tourm_Price extends Widget_Base {

	public function get_name() {
		return 'tourmprice';
	}
	public function get_title() {
		return __( 'Price Box', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'price_section',
			[
				'label' 	=> __( 'Price Box', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two'] );

		$repeater = new Repeater();

		tourm_media_fields( $repeater, 'icon_image', 'Icon Image' );
		tourm_general_fields( $repeater, 'plan_name', 'Plan Name', 'TEXT', 'Basic' );
		tourm_general_fields( $repeater, 'price', 'Price', 'TEXT', '$100.00' );
		tourm_general_fields( $repeater, 'subtitle', 'Subtitle', 'TEXT', 'Automatically connect with prospective clients' );
		tourm_general_fields( $repeater, 'desc', 'Features', 'WYSIWYG', 'Automatically connect with prospective clients' );

		tourm_general_fields($repeater, 'button_text', 'Button Text', 'TEXT', 'Button Text');
		tourm_url_fields($repeater, 'button_url', 'Button URL');

		tourm_switcher_fields( $repeater, 'is_popular', 'Is Popular?' );

		$this->add_control(
			'price_lists',
			[
				'label' 		=> __( 'Slides', 'tourm' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ plan_name }}}',
				'condition'		=> [ 
					'layout_style' => [ '1'],
				],
			]
		);


		$fields_to_include2 = ['title' => ['Title','Price', 'Unit', 'Description'],'btn' => ['Button Text'], 'url' => ['URL'] ];
		tourm_repeater_fields( $this, 'price_lists2', 'Price', $fields_to_include2, ['2'] );


		$this->end_controls_section();



		$this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Form General', 'tourm' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		tourm_color_fields( $this, 'bg', 'Background', 'background', '{{WRAPPER}} .bg' );  

		$this->end_controls_section();

		//-------Title Style-------
		tourm_common_style_fields( $this, 'tag', 'Title', '{{WRAPPER}} .title-tag', ['1'],'--theme-color' );
		tourm_common_style_fields( $this, 'price', 'Price', '{{WRAPPER}} .price', ['1'],'--theme-color' );
		tourm_common_style_fields( $this, 'features', 'Features', '{{WRAPPER}} .checklist', ['1'],'--title-color' );
		//------Button Style-------
		tourm_button_style_fields( $this, '11', 'Button Styling', '{{WRAPPER}} .th_btn', ['1'] );


		tourm_common_style_fields( $this, '12', 'Title', '{{WRAPPER}} h3', ['2'] );
		tourm_common_style_fields( $this, '13', 'Description', '{{WRAPPER}} p', ['2'] );

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="row gy-4 justify-content-center">';
				foreach( $settings['price_lists'] as $data ){
					echo '<div class="col-xl-4 col-md-6">';
						$active_class = ($data['is_popular'] == 'yes') ? 'active' : '';

	                    echo '<div class="price-card '.esc_attr( $active_class ).'">';
	                        echo '<div class="offer-tag">Popular</div>';
	                        echo '<div class="price-card_wrapp">';
	                            if(!empty($data['icon_image']['url'])){
			                        echo '<div class="price-card_icon">';
			                            echo tourm_img_tag( array(
											'url'   => esc_url( $data['icon_image']['url'] ),
										));
			                        echo '</div>';
			                    }
	                            if(!empty($data['plan_name'])){
			                        echo '<h3 class="box-title title-tag">'.esc_html($data['plan_name']).'</h3>';
			                    }
	                        echo '</div>';
	                        echo '<div class="price-card_content">';
	                            if(!empty($data['price'])){
			                        echo '<h4 class="price-card_price price">'.wp_kses_post($data['price']).'</h4>';
			                    }
	                            if(!empty($data['subtitle'])){
			                        echo '<p class="price-card_text">'.esc_html($data['subtitle']).'</p>';
			                    }
	                            if(!empty($data['desc'])){
									echo '<div class="checklist">'.wp_kses_post($data['desc']).'</div>';
								} 
	                        echo '</div>';
	                        if(!empty($data['button_text'])){
		                        echo '<div class="price-btn"><a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style3 w-100">'.esc_html($data['button_text']).'</a></div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}else{
			echo '<div class="row gy-4 gx-30 justify-content-center">';

				foreach( $settings['price_lists2'] as $data ){
	                echo '<div class="col-xxl-4 col-lg-6">';
	                    echo '<div class="price-card2 th-ani ">';
	                        echo '<div class="price-card2_wrapp">';
	                            echo '<div class="box-content">';
	                            	if(!empty($data['price'])){
		                                echo '<h4 class="price-card2_price">'.wp_kses_post($data['price']).'</h4>';
		                            }
		                            if(!empty($data['unit'])){
		                                echo '<h6 class="price-card2_text">'.esc_html($data['unit']).'</h6>';
		                            }
	                            echo '</div>';
	                            if(!empty($data['description'])){
		                            echo '<p class="box-text">'.esc_html($data['description']).'</p>';
		                        }
	                        echo '</div>';
	                        echo '<div class="box-wrapp">';
	                        	if(!empty($data['title'])){
		                            echo '<h3 class="box-title">'.esc_html($data['title']).'</h3>';
		                        }
	                            echo '<a href="'.esc_url( $data['url']['url'] ).'" class="line-btn2"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow3.svg" alt="">'.esc_html($data['button_text']).'</a>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}
	}
}